from flickr import *
import urllib.parse
from .baseau import *

class FlickrAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.authSecret = ''

    def SetBrand(self, brand):
        if brand == 'wondershare':
            self.appId = 'edbf15ca26488a43669c2ee38914ea25'
            self.appSecret = '4eb7ff8d3e3018b8'
            self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'


    def GetLoginURL(self):
        f = FlickrAPI(api_key=self.appId, api_secret=self.appSecret, callback_url=self.redirectURL)
        try:
            auth_props = f.get_authentication_tokens(perms='read')
            auth_url = auth_props['auth_url']
            self.authSecret = auth_props['oauth_token_secret']
            print('Secret:' + self.authSecret)
            return auth_url
        except BaseException as e:
            return ''

    def Logout(self):
        logoutURL = ''
        return

    def VerifyRedirectURL(self, url_str):
        if url_str.find(self.redirectURL) == 0:
            url = urllib.parse.urlparse(url_str)
            paramlist = urllib.parse.parse_qs(url.query)
            if paramlist.has_key('oauth_token') and paramlist.has_key('oauth_verifier'):
                auth_token = paramlist['oauth_token'][0]
                auth_verifier = paramlist['oauth_verifier'][0]
                try:
                    f = FlickrAPI(api_key=self.appId, api_secret=self.appSecret, oauth_token=auth_token, oauth_token_secret=self.authSecret, callback_url=self.redirectURL)
                    accessToken = f.get_auth_tokens(auth_verifier)
                    self.userName = accessToken['username']
                    self.accessToken = accessToken['oauth_token'] + '|' + accessToken['oauth_token_secret']
                    return BaseAU.VerifyCode.S_OK
                except FlickrAuthError as e:
                    self.accessError = e.msg
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG


    def SetAccessToken(self, token):
        try:
            authToken = token.split('|')
            f = FlickrAPI(api_key=self.appId, api_secret=self.appSecret, oauth_token=authToken[0], oauth_token_secret=authToken[1], callback_url=self.redirectURL)
            response = f.api_request('flickr.test.login')
            self.userName = response['user']['username']['_content']
            return True
        except FlickrAuthError as e:
            self.accessError = e.msg
        except Exception as e:
            self.accessError = str(e)
        return False

def CreateFlickrInstance():
    return FlickrAU()

# if __name__ == '__main__':
#     flickr = CreateFlickrInstance()
#     flickr.SetBrand('wondershare')
#     print(flickr.GetLoginURL())
#     c = raw_input('input :')
#     flickr.VerifyRedirectURL(c)
#     print(flickr.GetAccessToken())
#     print(flickr.GetUserName())
#     # flickr.SetAccessToken('72157658346532705-83133239e5d6e6cf|f97f263f11923cab')

